/*

  Fichier en-tete

  Gestion des donnes mtier
  pour les cartes CPS2ter et CPS3

*/

#ifndef _CPS_DATA_H
#define _CPS_DATA_H

#ifndef _CPSAPI_H

/* InformationsPorteur */
typedef struct CPS_InfosPorteur {
  UINT8 CodeCivilite    [2];
  UINT8 NomPatronym     [27];
  UINT8 NomMarital      [27];
  UINT8 Prenoms         [3][27];
  UINT8 PrenomUsuel     [27];
  UINT8 CodeLangues     [4][2];
  } CPS_InfosPorteur ;


/* InformationsCarte */
typedef struct CPS_InfosCarte {    
  UINT8 IdEmetteur      [11];
  UINT8 IdCarteLog      [10];
  UINT8 CategorieCarte  [2];
  UINT8 DateEmis        [8];
  UINT8 DateFinVal      [8];
} CPS_InfosCarte ;



typedef struct CPS_InfosPS2 {
  UINT8 TypeCarte           [2];
  UINT8 ModeleCarte         [8];
  UINT8 IdNatPS             [31];
  UINT8 CodeProfession      [2];
  UINT8 CodeMetier          [2];
  UINT8 NomExerc            [27];
  /* Nouveau champ pour le RPPS */
  UINT8 SpecOrdRPPS         [10];
  UINT8 SpecQual            [2];
  UINT8 NatureQual          [2];
  UINT8 Competence_1        [2];
  UINT8 NatureCompetence_1  [2];
  UINT8 Competence_2        [2];
  UINT8 NatureCompetence_2  [2];
  UINT8 DiscipPart          [2][2];   
  UINT8 DiscipSpec          [2];
  UINT8 SitProf             [2];
  UINT8 AttribComp          [4][2];   
  } CPS_InfosPS2 ;

/* SituationPS */
typedef struct CPS_SituationPS {          
  UINT8  ModeExerc       [2];
  UINT8  Statut          [2];
  UINT8  SpecExerc       [2];
  UINT8  NatureQual      [2];
  UINT8  IdStruct        [15];    /*@@MOD970228-2*/
  UINT8  StructSectActiv [/*2*/10];
  UINT8  StructJurid     [2];
  UINT8  StructRaisSoc   [40];    /* @@Mod970117 */
  UINT8  TabPharm        [2]; 
  UINT16 NoLogSit;                /*(@@MOD970219-1)*/
  UINT8  IdNatPSRemp     [31];
  UINT8  DateDebSit      [8];
  UINT8  DateFinSit      [8];
} CPS_SituationPS ;

/* fichier EFSitFact */
#define CPS_EFSitFactTemp    0xE0  
#define CPS_TagSitFac        0xA0               
#define CPS_TagSitNoLo       0x80
#define CPS_TagIdFact        0x81
#define CPS_TagInfConv       0x82
#define CPS_TagAgrement      0x83
#define CPS_TagAutoSign      0x84

/* Lecture Situation Facturation DAM */
typedef struct CPS_SitFacturationTab
  {                       
  UINT16 LienLogiqueSitPS;           /* Lien avec la situation d'exercice */
  UINT8  IdFacturation[10];          /* Identfiant Facturation: Type d'identifiant - Identifiant */
  UINT8  InfosConventionnelles[6];   /* Informations conventionnelles */
  UINT8  Agrements[6];               /* Agrements */
  UINT8  AutorisationSignature;      /* Autorisations a signer */
  } CPS_SitFacturationTab;

#define NombreSitFacturation   8

typedef struct CPS_SitFacturation
  {
  CPS_SitFacturationTab SitFacturationTab[NombreSitFacturation];
  } CPS_SitFacturation;
 
#endif

typedef CPS_InfosPorteur PTR CPS_InfosPorteur_PTR;
typedef CPS_InfosCarte PTR CPS_InfosCarte_PTR;
typedef CPS_InfosPS2 PTR CPS_InfosPS2_PTR;

void getInfosPorteur(CK_BYTE_PTR pBuffer, CK_ULONG ulBufLen, CPS_InfosPorteur_PTR psInfosPorteur);
void getInfosCarte(CK_BYTE_PTR pDataBuf, CK_ULONG ulBufLen, CPS_InfosCarte_PTR pIC);
void getInfosPS2(CK_BYTE_PTR pDataBuf, CK_ULONG ulBufLen, CPS_InfosPS2_PTR psInfosPS2);
void getSituation(CK_BYTE_PTR pBuffer, CK_ULONG ulBufLen, CPS_SituationPS * pI);
void getSituationFacturation(CK_BYTE_PTR pBufferR, CK_ULONG Lg, PUINT16 pNumSitFacturationExistantes, CPS_SitFacturation * pSitFac);

#endif
